using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEditor(typeof(HexCreatureSquadView))]
    public class HexCreatureSquadViewEditor : Editor
    {
        private SerializedProperty _unitPositions;
        private GameObject _gameObject;

        private void OnEnable()
        {
            _unitPositions = serializedObject.FindProperty("_unitPositions");
            _gameObject = (target as HexCreatureSquadView).gameObject;
        }

        private void OnSceneGUI()
        {
            if (Selection.Contains(_gameObject))
            {
                Handles.DrawPolyLine(HexHelper.GetTileCorners(_gameObject.transform.position));
                for (int i = 0; i < _unitPositions.arraySize; i++)
                {
                    SerializedProperty element = _unitPositions.GetArrayElementAtIndex(i);
                    Vector3 value = element.vector3Value;
                    Vector3 newValue = Handles.PositionHandle(value, Quaternion.identity);
                    if (value != newValue)
                    {
                        element.vector3Value = newValue;
                        serializedObject.ApplyModifiedProperties();
                    }
                }
            }
        }
    }
}
