using UnityEngine;

namespace PK
{
    public class HexCreatureSquadUnitView : MonoBehaviour
    {
        private static int _isMovingId = Animator.StringToHash("IsMoving");
        private static int _isAliveId = Animator.StringToHash("IsAlive");
        private static int _isAttackingId = Animator.StringToHash("IsAttacking");
        private static int _isHitId = Animator.StringToHash("IsHit");

        [SerializeField] private SpriteRenderer _renderer;
        [SerializeField] private Material _enemyMaterial;
        [SerializeField] private Material _attackableEnemyMaterial;
        [SerializeField] private Material _hoverMaterial;
        [SerializeField] private Material _hoverEnemyMaterial;
        [SerializeField] private Material _selectionMaterial;
        [SerializeField] private Animator _animator;

        private Material _defaultMaterial;

        private void Awake()
        {
            _defaultMaterial = _renderer.sharedMaterial;
            _renderer.sortingOrder = SortingOrder.ENTITY;
        }

        public void SetSelectionState(SquadSelectionState state)
        {
            switch (state)
            {
                case SquadSelectionState.None:
                    _renderer.sharedMaterial = _defaultMaterial;
                    break;
                case SquadSelectionState.AttackableEnemy:
                    _renderer.sharedMaterial = _attackableEnemyMaterial;
                    break;
                case SquadSelectionState.Hovered:
                    _renderer.sharedMaterial = _hoverMaterial;
                    break;
                case SquadSelectionState.HoveredEnemy:
                    _renderer.sharedMaterial = _hoverEnemyMaterial;
                    break;
                case SquadSelectionState.Selected:
                    _renderer.sharedMaterial = _selectionMaterial;
                    break;
            }
        }

        public void SetFlipX(bool flip)
        {
            _renderer.flipX = flip;
        }

        public void StartWalking()
        {
            _animator.SetBool(_isMovingId, true);
        }

        public void EndWalking()
        {
            _animator.SetBool(_isMovingId, false);
        }

        public void Kill()
        {
            transform.SetParent(transform.parent.parent, true);
            _animator.SetBool(_isAliveId, false);
            _renderer.sortingOrder = SortingOrder.ENTITY - 1;
        }

        public void Attack()
        {
            _animator.SetTrigger(_isAttackingId);
        }

        public void Hit()
        {
            _animator.SetTrigger(_isHitId);
        }
    }
}
