﻿using UnityEngine;

namespace PK
{
    public class HexCreatureView : HexEntityView
    {
        private HexCreature _creature;

        private SpriteRenderer _spriteRenderer;
        private Transform _transform;
        
        public override Bounds Bounds { get { return SpriteHelper.GetBounds(_spriteRenderer); } }
        public override Vector3 Position { get { return _transform.position; } }

        public override void Initialize(IEntityModelForView modelForView)
        {
            _uid = modelForView.Uid;
            _id = modelForView.Id;
            _creature = HexDatabase.Instance.GetCreature(_uid);

            if (_spriteRenderer == null)
            {
                _spriteRenderer = GetComponent<SpriteRenderer>();
                _spriteRenderer.material = HexMaterials.Instance.CreatureMaterial;
                _spriteRenderer.sortingOrder = SortingOrder.ENTITY;
                _transform = transform;
            }

            if (Application.isPlaying)
            {
                _spriteRenderer.enabled = modelForView.Enabled;
            }
            else
            {
                _spriteRenderer.sharedMaterial = modelForView.Enabled ? HexMaterials.Instance.CreatureMaterial : HexMaterials.Instance.ObjectInvisibleMaterial;
            }

            Move(modelForView.Position, Vector2.zero);
        }

        public override void SetActive(bool active)
        {
            if (Application.isPlaying)
            {
                _spriteRenderer.enabled = active;
            }
        }

        public override void Move(Vector2Int position, Vector2 offset)
        {
            _transform.position = GetPosition(position);
        }

        private static Vector3 GetPosition(Vector2Int position)
        {
            return HexHelper.GetTilePosition(position) + Vector3.back * 0.1f;
        }
    }
}
