﻿using UnityEngine;

namespace PK
{
    public abstract class HexEntityView : MonoBehaviour
    {
        public ulong Uid { get { return _uid; } }
        public ulong Id { get { return _id; } }
        public abstract Bounds Bounds { get; }
        public abstract Vector3 Position { get; }

        protected ulong _uid;
        protected ulong _id;

        public abstract void Initialize(IEntityModelForView modelForView);
        public abstract void Move(Vector2Int position, Vector2 offset);

        public virtual void SetActive(bool active)
        {
        }

        public virtual void Refresh(HexMapView view)
        {
        }
        
        public void Destroy()
        {
            if (Application.isPlaying)
            {
                Destroy(gameObject);
            }
            else
            {
                DestroyImmediate(gameObject);
            }
        }
    }
}
