Shader "Unlit/HexMask"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}

        [HideInInspector] _StencilRef("__sr", Float) = 1
    }
    SubShader
    {
        Blend SrcAlpha OneMinusSrcAlpha, One OneMinusSrcAlpha
        Cull Off
        ZWrite Off
        ColorMask 0

        Stencil
        {
            Ref[_StencilRef]
            Comp Always // always pass
            Pass Replace
        }

        Tags { "Queue" = "Transparent-1" }

        Pass
        {
            Tags { "LightMode" = "Universal2D" }

            HLSLPROGRAM
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"

            #pragma vertex DefaultVertex
            #pragma fragment DefaultFragment

            struct Attributes
            {
                float3 positionOS   : POSITION;
                float2 uv           : TEXCOORD0;
            };

            struct Varyings
            {
                float4 positionCS  : SV_POSITION;
                float2 uv          : TEXCOORD0;
            };

            TEXTURE2D(_MainTex);
            SAMPLER(sampler_MainTex);
            float4 _MainTex_ST;

            Varyings DefaultVertex(Attributes v)
            {
                Varyings o = (Varyings)0;
                o.positionCS = TransformObjectToHClip(v.positionOS);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                return o;
            }

            void DefaultFragment(Varyings i)
            {
                half4 col = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv);
                clip(col.a - 0.5);
            }
            ENDHLSL
        }
    }
}
