Shader "Unlit/HexObject"
{
    Properties
    {
        _MainTex("Texture", 2D) = "white" {}
        _OutlineColor("OutlineColor", Color) = (1, 1, 1, 1)
        _ShadowOffsetMultiplier("ShadowOffsetMultiplier", Vector) = (0.5, 0, 0, 0)
    }
    SubShader
    {
        Blend SrcAlpha OneMinusSrcAlpha, One OneMinusSrcAlpha
        Cull Off
        ZWrite Off

        Tags { "Queue" = "Transparent" }

        Pass
        {
            Tags { "LightMode" = "Universal2D" }

            HLSLPROGRAM
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
            #include "Shadows.hlsl"

            #pragma vertex DefaultVertex
            #pragma fragment DefaultFragment

            #pragma shader_feature_local_fragment _ _OUTLINE

            struct Attributes
            {
                float3 positionOS   : POSITION;
                float4 color        : COLOR;
                float2 uv           : TEXCOORD0;
            };

            struct Varyings
            {
                float4 positionCS   : SV_POSITION;
                float4 color        : COLOR;
                float2 uv           : TEXCOORD0;
                float2 screenUv     : TEXCOORD1;
            };

            TEXTURE2D(_MainTex);
            SAMPLER(sampler_MainTex);
            float4 _MainTex_ST;
            float4 _MainTex_TexelSize;

            float4 _OutlineColor;
            float4 _ShadowData;

            Varyings DefaultVertex(Attributes v)
            {
                Varyings o = (Varyings)0;
                o.positionCS = TransformObjectToHClip(v.positionOS);
                o.color = v.color;
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                o.screenUv = ComputeScreenPos(o.positionCS).xy;
                return o;
            }

            half4 DefaultFragment(Varyings i) : SV_Target
            {
                half4 main = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv);
                main = ApplyShadows(i.screenUv, _ShadowData, main);

#if defined(_OUTLINE)
                float2 offset = _MainTex_TexelSize.xy;
                float4 sample1 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv + float2(offset.x, 0));
                float4 sample2 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv - float2(offset.x, 0));
                float4 sample3 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv + float2(0, offset.y));
                float4 sample4 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv - float2(0, offset.y));

                if (main.a < 0.1f && (sample1.a > 0.1f || sample2.a > 0.1f || sample3.a > 0.1f || sample4.a > 0.1f))
                {
                    return _OutlineColor;
                }
#endif
                main *= i.color;
                main.rgb *= main.a;
                return main;
            }
            ENDHLSL
        }

        Pass
        {
            Blend One Zero

            Tags { "LightMode" = "Shadow2D" }

            HLSLPROGRAM
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
            #include "Shadows.hlsl"

            #pragma vertex DefaultVertex
            #pragma fragment DefaultFragment

            struct Attributes
            {
                float3 positionOS   : POSITION;
                float4 color        : COLOR;
                float2 uv           : TEXCOORD0;
                float4 boundsUv     : TANGENT;
            };

            struct Varyings
            {
                float4 positionCS   : SV_POSITION;
                float4 color        : COLOR;
                float2 uv           : TEXCOORD0;
            };

            TEXTURE2D(_MainTex);
            SAMPLER(sampler_MainTex);
            float4 _MainTex_ST;
            float4 _ShadowOffsetMultiplier;
            float4 _ShadowData;

            Varyings DefaultVertex(Attributes v)
            {
                Varyings o = (Varyings)0;
                o.positionCS = TransformObjectToHClip(v.positionOS - float3((v.boundsUv.y * _ShadowOffsetMultiplier.x + _ShadowOffsetMultiplier.z) * v.boundsUv.z, (v.boundsUv.y * _ShadowOffsetMultiplier.y + _ShadowOffsetMultiplier.w) * v.boundsUv.w, 0));
                o.color = v.color;
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                return o;
            }

            float3 DefaultFragment(Varyings i) : SV_Target
            {
                const half4 main = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv);
                clip(main.a - 0.5);
                return CastShadow(_ShadowData, i.color.a);
            }
            ENDHLSL
        }

        Pass
        {
            Name "SceneSelectionPass"
            Tags { "LightMode" = "SceneSelectionPass" }

            HLSLPROGRAM
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"

            #pragma vertex EditorPassVertex
            #pragma fragment EditorPassDepthFragment

            struct Attributes
            {
                float3 positionOS	: POSITION;
            };

            struct Varyings
            {
                float4 positionCS	: SV_POSITION;
            };

            Varyings EditorPassVertex(Attributes v)
            {
                Varyings o = (Varyings)0;
                o.positionCS = TransformObjectToHClip(v.positionOS);
                return o;
            }

            void EditorPassDepthFragment(Varyings i)
            {
            }

            ENDHLSL
         }
    }
}
